<?php
/**
 * SECURITY TEST SCRIPT
 *
 * Upload this file to your server and visit: yoursite.com/core/test_security.php
 * DELETE THIS FILE AFTER TESTING!
 */

require_once __DIR__ . '/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

echo "<h1>🔒 FxBrooks Security Test</h1>";
echo "<style>
    body { font-family: Arial, sans-serif; padding: 20px; }
    .pass { color: green; }
    .fail { color: red; }
    .box { background: #f5f5f5; padding: 15px; margin: 10px 0; border-radius: 5px; }
</style>";

// SMTP Configuration - UPDATE THESE VALUES
$smtpConfig = [
    'host' => 'nesaracapitalinvest.com',
    'port' => 465,
    'encryption' => 'ssl',
    'username' => 'support@nesaracapitalinvest.com',
    'password' => 'support@nesaracapitalinvest.com', // CHANGE THIS PASSWORD BEFORE UPLOADING
];

// Test 1: Check if SMTP email works
echo "<div class='box'>";
echo "<h3>Test 1: Email Function (SMTP)</h3>";

$testEmail = 'springtechhub@gmail.com';
$subject = 'FxBrooks Security Test - Email Working!';
$message = "
<html>
<body>
<h2>Security Email Test Successful!</h2>
<p>If you received this email, your security alerts are working correctly.</p>
<p><strong>Time:</strong> " . date('Y-m-d H:i:s') . "</p>
<p><strong>Server:</strong> " . ($_SERVER['HTTP_HOST'] ?? 'Unknown') . "</p>
</body>
</html>
";

try {
    $mail = new PHPMailer(true);

    // Server settings
    $mail->isSMTP();
    $mail->Host       = $smtpConfig['host'];
    $mail->SMTPAuth   = true;
    $mail->Username   = $smtpConfig['username'];
    $mail->Password   = $smtpConfig['password'];
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // SSL
    $mail->Port       = $smtpConfig['port'];
    $mail->CharSet    = 'UTF-8';

    // Recipients
    $mail->setFrom($smtpConfig['username'], 'FxBrooks Security');
    $mail->addAddress($testEmail);
    $mail->addReplyTo($smtpConfig['username'], 'FxBrooks Security');

    // Content
    $mail->isHTML(true);
    $mail->Subject = $subject;
    $mail->Body    = $message;

    $mail->send();
    echo "<p class='pass'>✅ PASS: Test email sent to {$testEmail}</p>";
    echo "<p>Check your inbox (and spam folder) for the test email.</p>";
} catch (Exception $e) {
    echo "<p class='fail'>❌ FAIL: Could not send email.</p>";
    echo "<p><strong>Error:</strong> " . htmlspecialchars($mail->ErrorInfo) . "</p>";
    echo "<p>Please check your SMTP configuration.</p>";
}
echo "</div>";

// Test 2: Check if security files exist
echo "<div class='box'>";
echo "<h3>Test 2: Security Files</h3>";

$files = [
    'app/Http/Middleware/GatewaySecurityMonitor.php' => 'Gateway Monitor',
    'app/Http/Middleware/FileIntegrityMonitor.php' => 'File Integrity Monitor',
    'app/Observers/GatewaySecurityObserver.php' => 'Gateway Observer',
];

foreach ($files as $file => $name) {
    if (file_exists(__DIR__ . '/' . $file)) {
        echo "<p class='pass'>✅ {$name}: Found</p>";
    } else {
        echo "<p class='fail'>❌ {$name}: NOT FOUND - {$file}</p>";
    }
}
echo "</div>";

// Test 3: Check if logging directory is writable
echo "<div class='box'>";
echo "<h3>Test 3: Log Directory</h3>";
$logDir = __DIR__ . '/storage/logs';
if (is_writable($logDir)) {
    echo "<p class='pass'>✅ PASS: Log directory is writable</p>";

    // Try writing a test log
    $testLog = $logDir . '/security_test.log';
    if (file_put_contents($testLog, "Security test at " . date('Y-m-d H:i:s') . "\n", FILE_APPEND)) {
        echo "<p class='pass'>✅ PASS: Can write to security log</p>";
    }
} else {
    echo "<p class='fail'>❌ FAIL: Log directory is not writable</p>";
}
echo "</div>";

// Test 4: Check ViserLab blocking
echo "<div class='box'>";
echo "<h3>Test 4: ViserLab Backdoor Blocked</h3>";

// Check CurlRequest.php
$curlFile = file_get_contents(__DIR__ . '/app/Lib/CurlRequest.php');
if (strpos($curlFile, 'viserlab.com') !== false && strpos($curlFile, 'blocked') !== false) {
    echo "<p class='pass'>✅ PASS: ViserLab server is blocked in CurlRequest</p>";
} else {
    echo "<p class='fail'>❌ FAIL: ViserLab blocking may not be active</p>";
}

// Check helpers.php
$helpersFile = file_get_contents(__DIR__ . '/app/Http/Helpers/helpers.php');
if (strpos($helpersFile, 'return null') !== false && strpos($helpersFile, 'getTemplates') !== false) {
    echo "<p class='pass'>✅ PASS: getTemplates() phone-home disabled</p>";
} else {
    echo "<p class='fail'>❌ FAIL: getTemplates() may still be active</p>";
}
echo "</div>";

// Test 5: Check template upload disabled
echo "<div class='box'>";
echo "<h3>Test 5: Template Upload Disabled</h3>";
$frontendController = file_get_contents(__DIR__ . '/app/Http/Controllers/Admin/FrontendController.php');
if (strpos($frontendController, 'Template upload has been disabled') !== false) {
    echo "<p class='pass'>✅ PASS: Template upload is disabled</p>";
} else {
    echo "<p class='fail'>❌ FAIL: Template upload may still be active</p>";
}
echo "</div>";

// Test 6: Check installer disabled
echo "<div class='box'>";
echo "<h3>Test 6: Installer Disabled</h3>";
$installerPath = dirname(__DIR__) . '/install/index.php';
if (file_exists($installerPath)) {
    $installerContent = file_get_contents($installerPath);
    if (strpos($installerContent, 'INSTALLER DISABLED') !== false) {
        echo "<p class='pass'>✅ PASS: Installer is disabled</p>";
        echo "<p>⚠️ Recommendation: Delete the /install folder entirely for extra security.</p>";
    } else {
        echo "<p class='fail'>❌ FAIL: Installer may still be active!</p>";
    }
} else {
    echo "<p class='pass'>✅ PASS: Install folder not found (good!)</p>";
}
echo "</div>";

// Summary
echo "<div class='box' style='background: #e8f5e9; border: 2px solid green;'>";
echo "<h3>📋 Summary</h3>";
echo "<p><strong>If all tests pass:</strong> Your security fixes are working!</p>";
echo "<p><strong>If email test passed:</strong> You'll receive alerts at {$testEmail}</p>";
echo "<p style='color: red; font-weight: bold;'>⚠️ DELETE THIS FILE (test_security.php) AFTER TESTING!</p>";
echo "</div>";

echo "<br><p><a href='javascript:history.back()'>← Go Back</a></p>";
?>
