<?php $__env->startSection('panel'); ?>
    <div class="preloader">
        <div class="animated-preloader"></div>
    </div>
    <div class="overlay"></div>
    <div class="header">
        <div class="container">
            <div class="header-bottom">
                <div class="header-bottom-area align-items-center">
                    <div class="logo"><a href="<?php echo e(route('home')); ?>"><img
                                src="<?php echo e(asset(getImage(getFilePath('logoIcon') . '/logo.png'))); ?>" alt="logo"></a></div>
                    <ul class="menu ms-auto">
                        <li>
                            <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('plan')); ?>"><?php echo app('translator')->get('Plan'); ?></a>
                        </li>
                        <?php
                            $pages = App\Models\Page::where('tempname', $activeTemplate)
                                ->where('is_default', 0)
                                ->get();
                        ?>
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('pages', [$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <li>
                            <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                        </li>
                        <?php if(auth()->check()): ?>
                            <li class="menu-btn">
                                <a href="<?php echo e(route('user.home')); ?>" class="ps-2"> <i class="las la-user"></i>
                                    <?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>
                        <?php else: ?>
                            <li>
                                <a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a>
                            </li>
                            <li class="menu-btn">
                                <a href="<?php echo e(route('user.login')); ?>"> <i class="las la-user"></i> <?php echo app('translator')->get('Login'); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                    <?php if($general->language_switch): ?>
                    <select name="langSel" class="langSel form--control h-auto px-2 py-1 border-0">
                        <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected <?php endif; ?>>
                                <?php echo e(__($item->name)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php endif; ?>
                    <div class="header-trigger-wrapper d-flex d-lg-none align-items-center">
                        <div class="header-trigger">
                            <span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php echo $__env->yieldContent('content'); ?>

    <?php
        $content = getContent('footer.content',true);
    ?>
    <!-- Footer Section -->
    <footer class="py-4">
        <div class="container">
            <div class="footer-content text-center">
                <a href="<?php echo e(route('home')); ?>" class="logo mb-3"><img
                        src="<?php echo e(asset(getImage(getFilePath('logoIcon') . '/logo_2.png'))); ?>" alt="images"></a>
                <p class="footer-text mx-auto"><?php echo e(__($content->data_values->content)); ?></p>
                <ul class="footer-links d-flex flex-wrap gap-3 justify-content-center mt-3 mb-3">
                    <li><a href="<?php echo e(route('home')); ?>" class="link-color"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li><a href="<?php echo e(route('contact')); ?>" class="link-color"><?php echo app('translator')->get('Contact'); ?></a></li>
                    <li><a href="<?php echo e(route('user.login')); ?>" class="link-color"><?php echo app('translator')->get('Sign In'); ?></a></li>
                    <li><a href="<?php echo e(route('user.register')); ?>" class="link-color"><?php echo app('translator')->get('Sign Up'); ?></a></li>
                </ul>
                <p class="copy-right-text">&copy; <?php echo e(date('Y')); ?> <a href="<?php echo e(route('home')); ?>"
                        class="text--base"><?php echo e(__($general->site_name)); ?></a>. <?php echo app('translator')->get('All Rights Reserved'); ?></p>
            </div>
        </div>
    </footer>
    <!-- Footer Section -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nesaraca/public_html/core/resources/views/templates/invester//layouts/frontend.blade.php ENDPATH**/ ?>