<?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="col-lg-4 col-md-4 col-sm-6">
        <div class="plan-item style--two text-center mw-100 w-100 h-100">
            <div class="plan-item__header">
                <h4 class="mb-1 plan-title"><?php echo e(__($plan->name)); ?></h4>
                <p class="mb-2">
                    <?php if($plan->lifetime == 0): ?>
                        <?php echo app('translator')->get('Total'); ?>
                        <?php echo e(__($plan->interest * $plan->repeat_time)); ?><?php echo e($plan->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                        <?php echo app('translator')->get('ROI'); ?>
                    <?php else: ?>
                        <?php echo app('translator')->get('Unlimited'); ?>
                    <?php endif; ?>
                </p>
                <div class="plan-rate">
                    <h3 class="rate">
                        <?php echo e($plan->interest_type != 1 ? $general->cur_sym : ''); ?><?php echo e(showAmount($plan->interest)); ?><?php echo e($plan->interest_type == 1 ? '%' : ''); ?>

                    </h3>
                    <p><?php echo app('translator')->get('EVERY'); ?> <?php echo e(__(strtoupper($plan->time_name))); ?> <?php echo app('translator')->get('FOR'); ?> <?php if($plan->lifetime == 0): ?>
                            <?php echo e(__($plan->repeat_time)); ?> <?php echo e(__($plan->time_name)); ?>

                        <?php else: ?>
                            <?php echo app('translator')->get('LIFETIME'); ?>
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <div class="plan-item__body my-4">
                <ul class="list list-style-three text-start">
                    <li class="d-flex flex-wrap justify-content-between align-items-center">
                        <span class="label"><?php echo app('translator')->get('Investment'); ?></span>
                        <span class="value">
                            <?php if($plan->fixed_amount == 0): ?>
                                <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->minimum)); ?> -
                                <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->maximum)); ?>

                            <?php else: ?>
                                <?php echo e(__($general->cur_sym)); ?><?php echo e(showAmount($plan->fixed_amount)); ?>

                            <?php endif; ?>
                        </span>
                    </li>
                    <li class="d-flex flex-wrap justify-content-between align-items-center">
                        <span class="label"><?php echo app('translator')->get('Max. Earn'); ?></span>
                        <span class="value">
                            <?php
                                if ($plan->fixed_amount == 0) {
                                    $investAmo = $plan->maximum;
                                } else {
                                    $investAmo = $plan->fixed_amount;
                                }

                                if ($plan->lifetime == 0) {
                                    if ($plan->interest_type == 1) {
                                        $interestAmo = (($investAmo * $plan->interest) / 100) * $plan->repeat_time;
                                    } else {
                                        $interestAmo = $plan->interest * $plan->repeat_time;
                                    }
                                } else {
                                    $interestAmo = 'Unlimited';
                                }

                            ?>

                            <?php echo e($interestAmo); ?> <?php if($plan->lifetime == 0): ?>
                                <?php echo e($general->cur_text); ?>

                            <?php endif; ?>
                        </span>
                    </li>
                    <li class="d-flex flex-wrap justify-content-between align-items-center">
                        <span class="label"><?php echo app('translator')->get('Total Return'); ?></span>
                        <span class="value">
                            <?php if($plan->lifetime == 0): ?>
                                <?php if($plan->capital_back == 1): ?>
                                    <?php echo app('translator')->get('capital'); ?> +
                                <?php endif; ?>
                                <?php echo e(__($plan->interest * $plan->repeat_time)); ?><?php echo e($plan->interest_type == 1 ? '%' : ' ' . __($general->cur_text)); ?>

                            <?php else: ?>
                                <?php echo app('translator')->get('Unlimited'); ?>
                            <?php endif; ?>
                        </span>
                    </li>
                </ul>
            </div>
            <button class="cmn--btn plan-btn btn mt-2 investModal" data-bs-toggle="modal"
                data-plan="<?php echo e($plan); ?>" data-bs-target="#investModal"
                type="button"><?php echo app('translator')->get('Invest Now'); ?></button>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


<div class="modal fade" id="investModal">
    <div class="modal-dialog modal-dialog-centered modal-content-bg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <?php if(auth()->check()): ?>
                        <?php echo app('translator')->get('Confirm to invest on'); ?> <span class="planName"></span>
                    <?php else: ?>
                        <?php echo app('translator')->get('At first sign in your account'); ?>
                    <?php endif; ?>
                </h5>
                <button type="button" class="close" data-bs-dismiss="modal">
                    <i class="las la-times"></i>
                </button>
            </div>
            <form action="<?php echo e(route('user.invest.submit')); ?>" method="post">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="plan_id">
                <?php if(auth()->check()): ?>
                    <div class="modal-body">
                        <div class="form-group">
                            <h6 class="text-center investAmountRange"></h6>
                            <p class="text-center mt-1 interestDetails"></p>
                            <p class="text-center interestValidity"></p>

                            <label><?php echo app('translator')->get('Select Wallet'); ?></label>
                            <select class="form-control form--control form-select" name="wallet_type" required>
                                <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                <?php if(auth()->user()->deposit_wallet > 0): ?>
                                <option value="deposit_wallet"><?php echo app('translator')->get('Deposit Wallet - '.$general->cur_sym.showAmount(auth()->user()->deposit_wallet)); ?></option>
                                <?php endif; ?>
                                <?php if(auth()->user()->interest_wallet > 0): ?>
                                <option value="interest_wallet"><?php echo app('translator')->get('Interest Wallet -'.$general->cur_sym.showAmount(auth()->user()->interest_wallet)); ?></option>
                                <?php endif; ?>
                                <?php $__currentLoopData = $gatewayCurrency; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($data->id); ?>" <?php if(old('wallet_type') == $data->method_code): echo 'selected'; endif; ?> data-gateway="<?php echo e($data); ?>"><?php echo e($data->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <code class="gateway-info rate-info d-none"><?php echo app('translator')->get('Rate'); ?>: 1 <?php echo e($general->cur_text); ?> = <span class="gateway-rate"></span> <span class="method_currency"></span></code>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Invest Amount'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control form--control" name="amount" required>
                                <div class="input-group-text"><?php echo e($general->cur_text); ?></div>
                            </div>
                            <code class="gateway-info d-none"><?php echo app('translator')->get('Charge'); ?>: <span class="charge"></span> <?php echo e($general->cur_text); ?>. <?php echo app('translator')->get('Total amount'); ?>: <span class="total"></span> <?php echo e($general->cur_text); ?></code>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="modal-footer">
                    <?php if(auth()->check()): ?>
                        <button type="button" class="btn btn--dark" data-bs-dismiss="modal"><?php echo app('translator')->get('No'); ?></button>
                        <button type="submit" class="btn btn--base"><?php echo app('translator')->get('Yes'); ?></button>
                    <?php else: ?>
                        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base w-100"><?php echo app('translator')->get('At first sign in your account'); ?></a>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
</div>


<?php $__env->startPush('script'); ?>
<script>
    (function($){
        "use strict"
        $('.investModal').click(function(){
            var symbol = '<?php echo e($general->cur_sym); ?>';
            var currency = '<?php echo e($general->cur_text); ?>';
            $('.gateway-info').addClass('d-none');
            var modal = $('#investModal');
            var plan = $(this).data('plan');
            modal.find('[name=plan_id]').val(plan.id);
            modal.find('.planName').text(plan.name);
            let fixedAmount = parseFloat(plan.fixed_amount).toFixed(2);
            let minimumAmount = parseFloat(plan.minimum).toFixed(2);
            let maximumAmount = parseFloat(plan.maximum).toFixed(2);
            let interestAmount = parseFloat(plan.interest);

            if (plan.fixed_amount > 0) {
                modal.find('.investAmountRange').text(`Invest: ${symbol}${fixedAmount}`);
                modal.find('[name=amount]').val(parseFloat(plan.fixed_amount).toFixed(2));
                modal.find('[name=amount]').attr('readonly',true);
            }else{
                modal.find('.investAmountRange').text(`Invest: ${symbol}${minimumAmount} - ${symbol}${maximumAmount}`);
                modal.find('[name=amount]').val('');
                modal.find('[name=amount]').removeAttr('readonly');
            }

            if (plan.interest_type == '1') {
                modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount}% </strong>`);
            } else {
                modal.find('.interestDetails').html(`<strong> Interest: ${interestAmount} ${currency}  </strong>`);
            }

            if (plan.lifetime == '0') {
                modal.find('.interestValidity').html(`<strong>  Every ${plan.time_name} for ${plan.repeat_time} times</strong>`);
            } else {
                modal.find('.interestValidity').html(`<strong>  Every ${plan.time_name} for life time </strong>`);
            }

        });

        $('[name=amount]').on('input',function(){
            $('[name=wallet_type]').trigger('change');
        })

        $('[name=wallet_type]').change(function () {
            var amount = $('[name=amount]').val();
            if($(this).val() != 'deposit_wallet' && $(this).val() != 'interest_wallet' && amount){
                var resource = $('select[name=wallet_type] option:selected').data('gateway');
                var fixed_charge = parseFloat(resource.fixed_charge);
                var percent_charge = parseFloat(resource.percent_charge);
                var charge = parseFloat(fixed_charge + (amount * percent_charge / 100)).toFixed(2);
                $('.charge').text(charge);
                $('.gateway-rate').text(parseFloat(resource.rate));
                $('.gateway-info').removeClass('d-none');
                if (resource.currency == '<?php echo e($general->cur_text); ?>') {
                    $('.rate-info').addClass('d-none');
                }else{
                    $('.rate-info').removeClass('d-none');
                }
                $('.method_currency').text(resource.currency);
                $('.total').text(parseFloat(charge) + parseFloat(amount));
            }else{
                $('.gateway-info').addClass('d-none');
            }
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>


<?php /**PATH /home/nesaraca/public_html/core/resources/views/templates/invester/partials/plan.blade.php ENDPATH**/ ?>