<?php $__env->startSection('content'); ?>
    <?php
        $plans = App\Models\Plan::where('status', 1)
            ->where('featured', 1)
            ->get();
        $gatewayCurrency = null;
        if (auth()->check()) {
            $gatewayCurrency = App\Models\GatewayCurrency::whereHas('method', function ($gate) {
                $gate->where('status', 1);
            })
                ->with('method')
                ->orderby('method_code')
                ->get();
        }
    ?>

    <section class="plan-section pt-120 pb-120 bg--light">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <?php echo $__env->make($activeTemplate . 'partials.plan', ['plans' => $plans], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <?php
                $workProcess = getContent('how_it_work.content', true);
                $workProcessElements = getContent('how_it_work.element', null, false, true);
            ?>

            <div class="how-it-work pt-5">
                <div class="mb-3">
                    <h4><?php echo e(__(@$workProcess->data_values->title)); ?></h4>
                    <p><?php echo __(@$workProcess->data_values->subtitle) ?></p>
                </div>
                <div class="row gy-4">
                    <?php $__currentLoopData = $workProcessElements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $process): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-3 col-sm-6">
                            <div class="work-process-card">
                                <div class="icon-area">
                                    <img src="<?php echo e(getImage('assets/images/frontend/how_it_work/' . $process->data_values->image, '50x50')); ?>" alt="">
                                </div>
                                <h5 class="my-1"><?php echo e(__($process->data_values->title)); ?></h5>
                                <p><?php echo e(__($process->data_values->content)); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/litpopfi/system.octetfinancepty.com/core/resources/views/templates/invester/home.blade.php ENDPATH**/ ?>