<?php $__env->startSection('content'); ?>
    <div class="dashboard-inner">
        <div class="mb-4">
            <div class="d-flex justify-content-between">
                <h3 class="mb-2"><?php echo app('translator')->get('Deposit History'); ?></h3>
                <span>
                    <a href="<?php echo e(route('user.deposit.index')); ?>" class="btn btn--secondary btn--smd"><?php echo app('translator')->get('Deposit Now'); ?> <i class="las la-long-arrow-alt-right"></i></a>
                </span>
            </div>
        </div>
        <div class="accordion table--acordion" id="transactionAccordion">
            <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="accordion-item transaction-item">
                    <h2 class="accordion-header" id="h-<?php echo e($loop->iteration); ?>">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-<?php echo e($loop->iteration); ?>" aria-expanded="false" aria-controls="c-1">
                            <div class="col-lg-4 col-sm-5 col-8 order-1 icon-wrapper">
                                <div class="left">
                                    <?php if($deposit->status == 1): ?>
                                        <div class="icon icon-success">
                                            <i class="las la-check"></i>
                                        </div>
                                    <?php elseif($deposit->status == 2): ?>
                                        <div class="icon icon-warning">
                                            <i class="las la-spinner fa-spin"></i>
                                        </div>
                                    <?php elseif($deposit->status == 3): ?>
                                        <div class="icon icon-danger">
                                            <i class="las la-ban"></i>
                                        </div>
                                    <?php endif; ?>
                                    <div class="content">
                                        <h6 class="trans-title"><?php echo e(__($deposit->gateway?->name)); ?></h6>
                                        <span class="text-muted font-size--14px mt-2"><?php echo e(showDateTime($deposit->created_at, 'M d Y @g:i:a')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-4 col-sm-4 col-12 order-sm-2 order-3 content-wrapper mt-sm-0 mt-3">
                                <p class="text-muted font-size--14px"><b>#<?php echo e($deposit->trx); ?></b></p>
                            </div>
                            <div class="col-lg-4 col-sm-3 col-4 order-sm-3 order-2 text-end amount-wrapper">
                                <p><b><?php echo e(showAmount($deposit->amount)); ?> <?php echo e($general->cur_text); ?></b></p>

                            </div>
                        </button>
                    </h2>
                    <div id="c-<?php echo e($loop->iteration); ?>" class="accordion-collapse collapse" aria-labelledby="h-1" data-bs-parent="#transactionAccordion">
                        <div class="accordion-body">
                            <ul class="caption-list">
                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Charge'); ?></span>
                                    <span class="value"><?php echo e(showAmount($deposit->charge)); ?> <?php echo e($general->cur_text); ?></span>
                                </li>
                                <li>
                                    <span class="caption"><?php echo app('translator')->get('With Charge'); ?></span>
                                    <span class="value"><?php echo e(showAmount($deposit->amount + $deposit->charge)); ?> <?php echo e(__($general->cur_text)); ?></span>
                                </li>
                                <li>
                                    <span class="caption"><?php echo app('translator')->get('Conversion'); ?></span>
                                    <span class="value"><?php echo e(showAmount($deposit->amount + $deposit->charge)); ?> <?php echo e(__($general->cur_text)); ?> x <?php echo e(showAmount($deposit->rate)); ?> <?php echo e(__($deposit->method_currency)); ?> = <?php echo e(showAmount($deposit->final_amo)); ?> <?php echo e(__($deposit->method_currency)); ?></span>
                                </li>
                                <li>
                                    <?php
                                        $details = $deposit->detail != null ? json_encode($deposit->detail) : null;
                                    ?>
                                    <span class="caption"><?php echo app('translator')->get('Status'); ?></span>
                                    <span class="value">
                                        <?php echo $deposit->statusBadge ?> <?php if($deposit->method_code >= 1000): ?>
                                            <a href="javascript:void(0)" class="detailBtn" data-info="<?php echo e($details); ?>" <?php if($deposit->status == 3): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>><i class="las la-info-circle"></i></a>
                                        <?php endif; ?>
                                    </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div><!-- transaction-item end -->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="accordion-body text-center bg-white">
                    <h4 class="text--muted"><i class="far fa-frown"></i> <?php echo e(__($emptyMessage)); ?></h4>
                </div>
            <?php endif; ?>
        </div>
        <div class="mt-3">
            <?php echo e($deposits->links()); ?>

        </div>
    </div>


    
    <div id="detailModal" class="modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData mb-2">
                    </ul>
                    <div class="feedback"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn--sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);


                modal.modal('show');
            });
        })(jQuery);
    </script>
    <script src="//code.jivosite.com/widget/E2plB0xikf" async></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pointhol/public_html/app/core/resources/views/templates/invester/user/deposit_history.blade.php ENDPATH**/ ?>