<?php
    $promotionCount = App\Models\PromotionTool::count();
?>
<div class="dashboard-sidebar" id="dashboard-sidebar">
    <button class="btn-close dash-sidebar-close d-xl-none"></button>
    <a href="<?php echo e(route('home')); ?>" class="logo"><img src="<?php echo e(asset(getImage(getFilePath('logoIcon').'/logo_2.png'))); ?>" alt="images"></a>
    <div class="bg--lights">
        <div class="profile-info">
            <p class="fs--13px mb-3 fw-bold"><?php echo app('translator')->get('ACCOUNT BALANCE'); ?></p>
            <h4 class="usd-balance text--base mb-2 fs--30"><?php echo e(showAmount(auth()->user()->deposit_wallet)); ?> <sub class="top-0 fs--13px"><?php echo e($general->cur_text); ?> <small>(<?php echo app('translator')->get('Deposit Wallet'); ?>)</small> </sub></h4>
            <p class="btc-balance fw-medium fs--18px"><?php echo e(showAmount(auth()->user()->interest_wallet)); ?> <sub class="top-0 fs--13px"><?php echo e($general->cur_text); ?> <small>(<?php echo app('translator')->get('Interest Wallet'); ?>)</small></sub></p>
            <div class="mt-4 d-flex flex-wrap gap-2">
                <a href="<?php echo e(route('user.deposit.index')); ?>" class="btn btn--base btn--smd"><?php echo app('translator')->get('Deposit'); ?></a>
                <a href="<?php echo e(route('user.withdraw')); ?>" class="btn btn--secondary btn--smd"><?php echo app('translator')->get('Withdraw'); ?></a>
            </div>
        </div>
    </div>
    <ul class="sidebar-menu">
        <li><a href="<?php echo e(route('user.home')); ?>" class="<?php echo e(menuActive('user.home')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/dashboard.png')); ?>" alt="icon"> <?php echo app('translator')->get('Dashboard'); ?></a></li>
        <li><a href="<?php echo e(route('user.invest.statistics')); ?>" class="<?php echo e(menuActive(['user.invest.statistics', 'user.invest.log', 'plan'])); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/investment.png')); ?>" alt="icon"> <?php echo app('translator')->get('Investments'); ?></a></li>
        <li><a href="<?php echo e(route('user.deposit.index')); ?>" class="<?php echo e(menuActive('user.deposit*')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/wallet.png')); ?>" alt="icon"> <?php echo app('translator')->get('Deposit'); ?></a></li>
        <li><a href="<?php echo e(route('user.withdraw')); ?>" class="<?php echo e(menuActive('user.withdraw*')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/withdraw.png')); ?>" alt="icon"> <?php echo app('translator')->get('Withdraw'); ?></a></li>
        <?php if($general->b_transfer): ?>
        <li><a href="<?php echo e(route('user.transfer.balance')); ?>" class="<?php echo e(menuActive('user.transfer.balance')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/balance-transfer.png')); ?>" alt="icon"> <?php echo app('translator')->get('Transfer Balance'); ?></a></li>
        <?php endif; ?>
        <li><a href="<?php echo e(route('user.transactions')); ?>" class="<?php echo e(menuActive('user.transactions')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/transaction.png')); ?>" alt="icon"> <?php echo app('translator')->get('Transactions'); ?></a></li>
        <li><a href="<?php echo e(route('user.referrals')); ?>" class="<?php echo e(menuActive('user.referrals')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/referral.png')); ?>" alt="icon"> <?php echo app('translator')->get('Referrals'); ?></a></li>
        <?php if($general->promotional_tool && $promotionCount): ?>
        <li><a href="<?php echo e(route('user.promotional.banner')); ?>" class="<?php echo e(menuActive('user.promotional.banner')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/promotion.png')); ?>" alt="icon"> <?php echo app('translator')->get('Promotional Banner'); ?></a></li>
        <?php endif; ?>

        <li><a href="<?php echo e(route('ticket.index')); ?>" class="<?php echo e(menuActive(['ticket', 'ticket.view', 'ticket.open'])); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/ticket.png')); ?>" alt="icon"> <?php echo app('translator')->get('Support Ticket'); ?></a></li>
        <li><a href="<?php echo e(route('user.twofactor')); ?>" class="<?php echo e(menuActive('user.twofactor')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/2fa.png')); ?>" alt="icon"> <?php echo app('translator')->get('2FA'); ?></a></li>
        <li><a href="<?php echo e(route('user.profile.setting')); ?>" class="<?php echo e(menuActive('user.profile.setting')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/profile.png')); ?>" alt="icon"> <?php echo app('translator')->get('Profile'); ?></a></li>
        <li><a href="<?php echo e(route('user.change.password')); ?>" class="<?php echo e(menuActive('user.change.password')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/password.png')); ?>" alt="icon"> <?php echo app('translator')->get('Change Password'); ?></a></li>
        <li><a href="<?php echo e(route('user.logout')); ?>" class="<?php echo e(menuActive('user.logout')); ?>"><img src="<?php echo e(asset($activeTemplateTrue.'/images/icon/logout.png')); ?>" alt="icon"> <?php echo app('translator')->get('Logout'); ?></a></li>
    </ul>
</div>
<?php /**PATH /home/litpopfi/octetfinancepty.com/app/core/resources/views/templates/invester/partials/sidebar.blade.php ENDPATH**/ ?>