<?php $__env->startSection('content'); ?>

    <div class="dashboard-inner">
        <div class="row justify-content-center">
            <div class="<?php if(!auth()->user()->ts): ?> col-md-12 <?php else: ?> col-md-8 <?php endif; ?>">
                <div class="mb-4">
                    <h3><?php echo app('translator')->get('Two Factor Authentication'); ?></h3>
                    <?php if(!auth()->user()->ts): ?>
                    <p><?php echo app('translator')->get('Your account will be more secure if you use this feature. A 6-digit verification code from your Android Google Authenticator app must be entered whenever someone tries to log in to the account. So that the system could verify that, this is you. Additionally, the payout procedure will require this verification.'); ?></p>
                    <?php else: ?>
                    <p><?php echo app('translator')->get('If you think that you don\'t need the 2FA verification, You\'ve a way to disable it. But before disabling this, the system warns you that your account could be at a security risk. The System recommendation is to enable 2FA security.'); ?></p>
                    <?php endif; ?>
                </div>
                <div class="row gy-4">

                    <?php if(!auth()->user()->ts): ?>
                    <div class="col-md-6">
                        <div class="card custom--card">
                            <div class="card-header">
                                <h5 class="mb-0"><?php echo app('translator')->get('Add Your Account'); ?></h5>
                            </div>

                            <div class="card-body">
                                <h6 class="mb-3">
                                    <?php echo app('translator')->get('Use the QR code or setup key on your Google Authenticator app to add your account. '); ?>
                                </h6>

                                <div class="form-group mb-3 mx-auto text-center">
                                    <img class="mx-auto" src="<?php echo e($qrCodeUrl); ?>">
                                </div>

                                <div class="form-group mb-3">
                                    <label class="form-label"><?php echo app('translator')->get('Setup Key'); ?></label>
                                    <div class="copy-link">
                                        <input type="text" class="copyURL" value="<?php echo e($secret); ?>" readonly>
                                        <span class="copyBoard" id="copyBoard"><i class="las la-copy"></i> <strong class="copyText"><?php echo app('translator')->get('Copy'); ?></strong></span>
                                    </div>
                                </div>

                                <label><i class="fa fa-info-circle"></i> <?php echo app('translator')->get('Help'); ?></label>
                                <p><?php echo app('translator')->get('Google Authenticator is a multifactor app for mobile devices. It generates timed codes used during the 2-step verification process. To use Google Authenticator, install the Google Authenticator application on your mobile device.'); ?> <a class="text--base" href="https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2&hl=en" target="_blank"><?php echo app('translator')->get('Download'); ?></a></p>
                            </div>
                        </div>
                    </div>

                    <?php endif; ?>

                    <div class="<?php if(!auth()->user()->ts): ?> col-md-6 <?php else: ?> col-md-12 <?php endif; ?>">

                        <?php if(auth()->user()->ts): ?>
                            <div class="card custom--card">
                                <div class="card-header">
                                    <h5 class="mb-0"><?php echo app('translator')->get('Disable 2FA Security'); ?></h5>
                                </div>
                                <form action="<?php echo e(route('user.twofactor.disable')); ?>" method="POST">
                                    <div class="card-body">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                                        <div class="form-group mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('Google Authenticatior OTP'); ?></label>
                                            <input type="text" class="form-control form--control" name="code" required>
                                        </div>
                                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                    </div>
                                </form>
                            </div>
                        <?php else: ?>
                            <div class="card custom--card">
                                <div class="card-header">
                                    <h5 class="mb-0"><?php echo app('translator')->get('Enable 2FA Security'); ?></h5>
                                </div>
                                <form action="<?php echo e(route('user.twofactor.enable')); ?>" method="POST">
                                    <div class="card-body">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="key" value="<?php echo e($secret); ?>">
                                        <div class="form-group mb-3">
                                            <label class="form-label"><?php echo app('translator')->get('Google Authenticatior OTP'); ?></label>
                                            <input type="text" class="form-control form--control" name="code" required>
                                        </div>
                                        <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                    </div>
                                </form>
                            </div>
                        <?php endif; ?>
                    </div>

                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($){
            "use strict";
            $('#copyBoard').click(function(){
                var copyText = document.getElementsByClassName("copyURL");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                /*For mobile devices*/
                document.execCommand("copy");
                $('.copyText').text('Copied');
                setTimeout(() => {
                    $('.copyText').text('Copy');
                }, 2000);
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pointhol/public_html/app/core/resources/views/templates/invester/user/twofactor.blade.php ENDPATH**/ ?>