<?php $__env->startSection('content'); ?>
<div class="dashboard-inner">
    <div class="mb-4">
        <p><?php echo app('translator')->get('Transaction'); ?></p>
        <h3><?php echo app('translator')->get('My Transactions History'); ?></h3>
    </div>
    <hr>
    <div class="filter-area mb-3">
        <div class="d-flex flex-wrap gap-4">
            <div class="flex-grow-1">
                <form action="">
                    <div class="custom-input-box trx-search">
                        <label><?php echo app('translator')->get('Transaction Number'); ?></label>
                        <input type="text" name="search" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Transaction Number'); ?>">
                        <button type="submit" class="icon-area">
                            <i class="las la-search"></i>
                        </button>
                    </div>
                </form>
            </div>
            <div class="flex-grow-1">
                <div class="custom-input-box">
                    <label><?php echo app('translator')->get('Wallet'); ?></label>
                    <select name="wallet_type" onChange="window.location.href=this.value">
                        <option value=<?php echo e(queryBuild('wallet','')); ?>><?php echo app('translator')->get('All'); ?></option>
                        <option value="<?php echo e(queryBuild('wallet_type','deposit_wallet')); ?>" <?php if(request()->wallet_type == 'deposit_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Deposit Wallet'); ?></option>
                        <option value="<?php echo e(queryBuild('wallet_type','interest_wallet')); ?>" <?php if(request()->wallet_type == 'interest_wallet'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Interest Wallet'); ?></option>
                    </select>
                </div>
            </div>
            <div class="flex-grow-1">
                <div class="custom-input-box">
                    <label><?php echo app('translator')->get('Type'); ?></label>
                    <select name="trx_type" onChange="window.location.href=this.value">
                        <option value="<?php echo e(queryBuild('trx_type','')); ?>"><?php echo app('translator')->get('All'); ?></option>
                        <option value="<?php echo e(queryBuild('trx_type','%2B')); ?>" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                        <option value="<?php echo e(queryBuild('trx_type','-')); ?>" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                    </select>
                </div>
            </div>
            <div class="flex-grow-1">
                <div class="custom-input-box">
                    <label><?php echo app('translator')->get('Remark'); ?></label>
                    <select name="remark" onChange="window.location.href=this.value">
                        <option value="<?php echo e(queryBuild('remark','')); ?>"><?php echo app('translator')->get('Any'); ?></option>
                        <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e(queryBuild('remark',$remark->remark)); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>><?php echo e(__(keyToTitle($remark->remark))); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <div class="accordion table--acordion" id="transactionAccordion">
        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="accordion-item transaction-item">
                <h2 class="accordion-header" id="h-<?php echo e($loop->iteration); ?>">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#c-<?php echo e($loop->iteration); ?>">
                    <div class="col-lg-4 col-sm-5 col-8 order-1 icon-wrapper">
                        <div class="left">
                            <div class="icon tr-icon <?php if($transaction->trx_type == '+'): ?> icon-success <?php else: ?> icon-danger <?php endif; ?>">
                                <i class="las la-long-arrow-alt-right"></i>
                            </div>
                            <div class="content">
                                <h6 class="trans-title"><?php echo e(__(keyToTitle($transaction->remark))); ?> - <?php echo e(__(keyToTitle($transaction->wallet_type))); ?></h6>
                                <span class="text-muted font-size--14px mt-2"><?php echo e(showDateTime($transaction->created_at,'M d Y @g:i:a')); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-sm-4 col-12 order-sm-2 order-3 content-wrapper mt-sm-0 mt-3">
                        <p class="text-muted font-size--14px"><b>#<?php echo e($transaction->trx); ?></b></p>
                    </div>
                    <div class="col-lg-4 col-sm-3 col-4 order-sm-3 order-2 text-end amount-wrapper">
                        <p>
                            <b><?php echo e(showAmount($transaction->amount )); ?> <?php echo e($general->cur_text); ?></b><br>
                            <small class="fw-bold text-muted"><?php echo app('translator')->get('Balance'); ?>: <?php echo e(showAmount($transaction->post_balance)); ?> <?php echo e($general->cur_text); ?></small>
                        </p>

                    </div>
                </button>
                </h2>
                <div id="c-<?php echo e($loop->iteration); ?>" class="accordion-collapse collapse" aria-labelledby="h-1" data-bs-parent="#transactionAccordion">
                    <div class="accordion-body">
                        <ul class="caption-list">
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Charge'); ?></span>
                                <span class="value"><?php echo e(showAmount($transaction->charge)); ?> <?php echo e($general->cur_text); ?></span>
                            </li>
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Post Balance'); ?></span>
                                <span class="value"><?php echo e(showAmount($transaction->post_balance)); ?> <?php echo e($general->cur_text); ?></span>
                            </li>
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Details'); ?></span>
                                <span class="value"><?php echo e(__($transaction->details)); ?></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div><!-- transaction-item end -->
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="accordion-body text-center">
                <h4 class="text--muted"><i class="far fa-frown"></i> <?php echo e(__($emptyMessage)); ?></h4>
            </div>
        <?php endif; ?>
    </div>


    <?php if($transactions->hasPages()): ?>
        <div class="mt-4">
            <?php echo e($transactions->links()); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .trx-search{
            position: relative;
        }
        .trx-search .icon-area{
            position: absolute;
            top: 10px;
            right: 8px;
            font-size: 20px;
            background: transparent;
            border: none;
        }
    </style>
<script src="//code.jivosite.com/widget/E2plB0xikf" async></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/litpopfi/octetfinancepty.com/app/core/resources/views/templates/invester/user/transactions.blade.php ENDPATH**/ ?>